using UnityEngine;

public class GameManagerScript : MonoBehaviour {
	public GameObject playerPrefab;
	public CountryManagerScript countries;
	
	private PlayerScript[] playerz = {null, null};
	private int activePlayer = -1;
	
	public int GetActivePlayer() { return activePlayer; }
	
	public static GameManagerScript instance;
	
	private GUITexture[] uiPlayers = {null, null};
	private Renderer[] uiCountries = {null, null};
	private GUITexture[] uiHealth = {null, null};
	
	private int[] playerCountries = {0,0};
	
	private bool gameOver = false;
	
	private GameObject god;
	
	private GameObject wikiInfo;
	
	void Awake() {
		instance = this;
	}

	void Start() {
		ChosenPlayers pl = ChosenPlayers.GetInstance();

		wikiInfo = transform.Find("WikiInfo").gameObject;
		god = transform.Find("God").gameObject;
		
		uiPlayers[0] = transform.Find("/UI/Flag1").guiTexture;
		uiPlayers[1] = transform.Find("/UI/Flag2").guiTexture;
		uiHealth[0] = transform.Find("/UI/Health1").guiTexture;
		uiHealth[1] = transform.Find("/UI/Health2").guiTexture;
		
		Transform et = GameObject.FindWithTag("Earth").transform;
		uiCountries[0] = transform.Find("/UICountry1").renderer;
		uiCountries[1] = transform.Find("/UICountry2").renderer;
		uiCountries[0].transform.rotation = et.rotation;
		uiCountries[1].transform.rotation = et.rotation;
		playerCountries[0] = pl.player1+1;
		playerCountries[1] = pl.player2+1;
		uiCountries[0].material.SetFloat("_Active", (float)(playerCountries[0])*8.0f/255.0f);
		uiCountries[1].material.SetFloat("_Active", (float)(playerCountries[1])*8.0f/255.0f);
		
		uiPlayers[0].texture = countries.flagsBig[playerCountries[0]-1];
		uiPlayers[1].texture = countries.flagsBig[playerCountries[1]-1];
		
		playerz[0] = createPlayer((Country)playerCountries[0]);
		playerz[1] = createPlayer((Country)playerCountries[1]);
		
		SwitchPlayer();
	}
	
	PlayerScript createPlayer( Country country )
	{
		GameObject player  = (GameObject)Instantiate(playerPrefab);
		PlayerScript pscript = (PlayerScript)player.GetComponent(typeof(PlayerScript));
		pscript.country = country;
		return pscript;
	}
	
	public void SwitchPlayer ()
	{
		if (gameOver)
			return;
		if( activePlayer != -1 ) {
			playerz[activePlayer].hideCanon();
		} else {
			activePlayer = 1;
		}
		
		uiPlayers[activePlayer].color = new Color(0.5f,0.5f,0.5f,0.15f);
		uiCountries[activePlayer].enabled = true;
		
		activePlayer = (activePlayer+1) & 1;
		
		uiPlayers[activePlayer].color = new Color(0.5f,0.5f,0.5f,0.5f);
		uiCountries[activePlayer].enabled = false;
		playerz[activePlayer].showCanon();
	}
	
	public void HitCountry (CountryHit chit)
	{
		if (chit.country == playerCountries[0]) {
			float alpha = (float)chit.left / (float)Mathf.Max(chit.total,1);
			Rect rc = uiHealth[0].pixelInset;
			rc.width = 24.0f + alpha * (128.0f-24.0f);
			uiHealth[0].pixelInset = rc;
		}
		if (chit.country == playerCountries[1]) {
			float alpha = (float)chit.left / (float)Mathf.Max(chit.total,1);
			Rect rc = uiHealth[1].pixelInset;
			rc.width = 24.0f + alpha * (128.0f-24.0f);
			uiHealth[1].pixelInset = rc;
		}
		if (chit.left > 0)
			return;
			
		// nuked a country, slow down the game and show it's text
		((ShowDeathInfo)wikiInfo.GetComponent(typeof(ShowDeathInfo))).StartCoroutine ("DoShow", countries.histories[chit.country-1].text);

		if (chit.country==playerCountries[0] || chit.country==playerCountries[1]) {
			// disable player stuff
			gameOver = true;
			playerz[0].hideCanon(); Destroy(playerz[0].gameObject);
			playerz[1].hideCanon(); Destroy(playerz[1].gameObject);
			// rise the god
			god.active = true;
			god.transform.Find("Plane").gameObject.active = true;
			GameObject flag = god.transform.Find("Flag").gameObject;
			flag.active = true;
			flag.renderer.material.mainTexture = 
				(chit.country==playerCountries[0]) ?
				uiPlayers[1].texture :
				uiPlayers[0].texture;
				
			Invoke ("LoadMainMenu", 18.0f);
		}
	}
	
	void Update() {
		if (Input.GetKeyDown("escape"))
			Application.LoadLevel(Application.loadedLevel-1);
	}
	
	public void LoadMainMenu () {
		Application.LoadLevel(0);
	}
}
